/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.irc.pircbotx;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.irc.AbstractChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcChannel;
import net.creeperhost.minetogether.lib.chat.irc.IrcClient;
import net.creeperhost.minetogether.lib.chat.irc.IrcState;
import net.creeperhost.minetogether.lib.chat.irc.IrcUser;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.PircBotChannel;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.PircBotUser;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.event.EventSubscriberListener;
import net.creeperhost.minetogether.lib.chat.irc.pircbotx.event.SubscribeEvent;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.request.IRCServerListRequest;
import net.creeperhost.minetogether.lib.chat.request.IRCServerListResponse;
import net.creeperhost.minetogether.lib.chat.util.HashLength;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.repack.org.pircbotx.Channel;
import net.creeperhost.minetogether.repack.org.pircbotx.Configuration;
import net.creeperhost.minetogether.repack.org.pircbotx.PircBotX;
import net.creeperhost.minetogether.repack.org.pircbotx.User;
import net.creeperhost.minetogether.repack.org.pircbotx.delay.StaticReadonlyDelay;
import net.creeperhost.minetogether.repack.org.pircbotx.exception.IrcException;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.ConnectEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.DisconnectEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.JoinEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.KickEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.MessageEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.NickAlreadyInUseEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.NoticeEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.PrivateMessageEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.QuitEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.RemoveChannelBanEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.SetChannelBanEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.UnknownCTCPEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.UserListEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.VoiceEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.events.WhoisEvent;
import net.creeperhost.minetogether.repack.org.pircbotx.hooks.managers.SequentialListenerManager;
import net.creeperhost.minetogether.repack.org.pircbotx.snapshot.UserSnapshot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PircBotClient
implements IrcClient {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChatState chatState;
    private final String nick;
    private final Supplier<String> realName;
    @Nullable
    private Thread clientThread;
    @Nullable
    private PircBotX client;
    @Nullable
    private IRCServerListResponse serverDetails;
    private final Map<Profile, PircBotUser> users = new HashMap<Profile, PircBotUser>();
    private final Map<String, PircBotChannel> channels = new HashMap<String, PircBotChannel>();
    private final List<IrcClient.ChannelListener> channelListeners = new LinkedList<IrcClient.ChannelListener>();
    private IrcState state = IrcState.DISCONNECTED;

    public PircBotClient(ChatState chatState, Supplier<String> realName) {
        this.chatState = chatState;
        this.nick = "MT" + HashLength.MEDIUM.format(chatState.auth.getHash());
        this.realName = realName;
    }

    private void startClient() {
        this.clientThread = new Thread(() -> {
            LOGGER.debug("Starting Pircbotx MineTogether thread.");
            try {
                ApiClientResponse<IRCServerListResponse> response = this.chatState.api.execute(new IRCServerListRequest());
                this.serverDetails = response.apiResponse();
                LOGGER.info("Starting IRC. Channel: {}", (Object)this.serverDetails.getChannel());
                EventSubscriberListener eventListener = new EventSubscriberListener();
                eventListener.addListener(this);
                Configuration config = new Configuration.Builder().setName(this.nick).setRealName(this.realName.get()).setLogin("MineTogether").setListenerManager(SequentialListenerManager.newDefault().addListenerSequential(eventListener)).setSnapshotsEnabled(false).setAutoReconnect(true).setAutoReconnectAttempts(-1).setAutoReconnectDelay(new StaticReadonlyDelay(TimeUnit.SECONDS.toMillis(5L))).setSocketTimeout((int)TimeUnit.SECONDS.toMillis(30L)).setEncoding(StandardCharsets.UTF_8).addAutoJoinChannel(this.serverDetails.getChannel()).addServer(this.serverDetails.getServer().getAddress(), this.serverDetails.getServer().getPort()).buildConfiguration();
                this.client = new PircBotX(config);
                this.client.startBot();
            }
            catch (IOException | IrcException ex) {
                this.state = IrcState.CRASHED;
                LOGGER.error("Unrecoverable error occurred with IRC client.", (Throwable)ex);
            }
            this.client = null;
            LOGGER.info("Exiting Pircbotx MineTogether thread.");
        });
        this.clientThread.setName("MineTogether IRC Client");
        this.clientThread.setDaemon(true);
        this.clientThread.start();
    }

    @Override
    public void start() {
        if (this.chatState.auth.getSessionToken() == null) {
            LOGGER.info("Refusing to start IRCClient. User has no session.");
            return;
        }
        if (this.state == IrcState.DISCONNECTED || this.state == IrcState.CRASHED) {
            LOGGER.info("Starting MineTogether IRCClient.");
            this.state = IrcState.CONNECTING;
            this.startClient();
        }
    }

    @Override
    public void stop() {
        if (this.client != null) {
            LOGGER.info("Stopping MineTogether IRCClient.");
            this.client.stopBotReconnect();
            try {
                this.client.sendIRC().quitServer();
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to send quit message..", ex);
            }
        }
    }

    @Override
    public IrcState getState() {
        return this.state;
    }

    @Override
    public Profile getUserProfile() {
        return this.chatState.profileManager.getOwnProfile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IrcUser getUser(Profile profile) {
        Map<Profile, PircBotUser> map = this.users;
        synchronized (map) {
            return this.users.get(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PircBotUser computeUser(User ircUser) {
        Profile profile = this.chatState.profileManager.lookupProfileStale(ircUser.getNick());
        Map<Profile, PircBotUser> map = this.users;
        synchronized (map) {
            return this.users.computeIfAbsent(profile, p -> new PircBotUser(this.client, this.chatState, (Profile)p));
        }
    }

    @Override
    @Nullable
    public PircBotChannel getPrimaryChannel() {
        if (this.serverDetails == null) {
            return null;
        }
        return this.getChannel(this.serverDetails.getChannel());
    }

    @Override
    @Nullable
    public PircBotChannel getChannel(String name) {
        return this.channels.get(name);
    }

    @Override
    public Collection<IrcChannel> getChannels() {
        return Collections.unmodifiableCollection(this.channels.values());
    }

    @Override
    public void addChannelListener(IrcClient.ChannelListener listener) {
        this.channelListeners.add(listener);
    }

    @Override
    public void removeChannelListener(IrcClient.ChannelListener listener) {
        this.channelListeners.remove(listener);
    }

    @SubscribeEvent
    private void onConnectEvent(ConnectEvent event) {
        try {
            Method method = PircBotX.class.getDeclaredMethod("setNick", String.class);
            method.setAccessible(true);
            method.invoke((Object)this.client, this.nick);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    private void onNickInUse(NickAlreadyInUseEvent event) {
        LOGGER.error("Nickname already in use.");
        this.state = IrcState.CRASHED;
        this.client.stopBotReconnect();
        this.client.sendIRC().quitServer();
    }

    @SubscribeEvent
    private void onConnected(ConnectEvent event) {
        LOGGER.info("Connected to MineTogether IRC.");
        this.state = IrcState.VERIFYING;
    }

    @SubscribeEvent
    private void onDisconnected(DisconnectEvent event) {
        LOGGER.info("Disconnected from MineTogether IRC.");
        if (this.state != IrcState.BANNED) {
            this.state = IrcState.DISCONNECTED;
        }
        for (PircBotChannel channel : this.channels.values()) {
            channel.bindChannel(null);
        }
    }

    @SubscribeEvent
    private void onJoin(JoinEvent event) {
        User ircUser = event.getUser();
        if (ircUser == null) {
            return;
        }
        if (!event.getChannel().getName().equals(this.serverDetails.getChannel())) {
            return;
        }
        this.userSeen(ircUser);
    }

    @SubscribeEvent
    private void onQuit(QuitEvent event) {
        UserSnapshot ircUser = event.getUser();
        if (ircUser == null) {
            return;
        }
        PircBotUser user = this.computeUser(ircUser);
        if (user.getProfile() != this.getUserProfile()) {
            user.bindIrcUser(null);
            this.chatState.profileManager.onUserOffline(user.getProfile());
        }
    }

    @SubscribeEvent
    private void onKicked(KickEvent event) {
        User ircUser = event.getUser();
        if (ircUser == null) {
            return;
        }
        if (!event.getChannel().getName().equals(this.serverDetails.getChannel())) {
            return;
        }
        PircBotUser user = this.computeUser(ircUser);
        if (user.getProfile() != this.getUserProfile()) {
            user.bindIrcUser(null);
        }
    }

    @SubscribeEvent
    private void onMessage(MessageEvent event) {
        User ircUser = event.getUser();
        Profile sender = this.chatState.profileManager.lookupProfile(ircUser.getNick());
        PircBotChannel channel = this.channels.get(event.getChannel().getName());
        if (channel != null) {
            channel.addMessage(Instant.ofEpochMilli(event.getTimestamp()), sender, event.getMessage());
        }
        if (this.chatState.logChatToConsole) {
            LOGGER.info("{}: {} | {}", (Object)event.getChannel().getName(), (Object)sender.getDisplayName(), (Object)event.getMessage());
        }
        if (channel.getName().equals(this.serverDetails.getChannel()) && !sender.newProfileWhoDis) {
            sender.newProfileWhoDis = true;
            ircUser.send().whois();
        }
    }

    @SubscribeEvent
    private void onPrivateMessage(PrivateMessageEvent event) {
        User ircUser = event.getUser();
        Profile sender = this.chatState.profileManager.lookupProfile(ircUser.getNick());
        IrcUser user = this.getUser(sender);
        if (user != null) {
            ((AbstractChannel)user.getChannel()).addMessage(Instant.ofEpochMilli(event.getTimestamp()), sender, event.getMessage());
        }
        if (this.chatState.logChatToConsole) {
            LOGGER.info("{}: {}", (Object)sender.getDisplayName(), (Object)event.getMessage());
        }
        if (!sender.newProfileWhoDis) {
            sender.newProfileWhoDis = true;
            ircUser.send().whois();
        }
    }

    @SubscribeEvent
    private void onNotice(NoticeEvent event) {
        String nick = event.getUser() != null ? event.getUser().getNick() : null;
        String cName = event.getChannel() != null ? event.getChannel().getName() : null;
        PircBotChannel channel = cName != null ? this.channels.get(cName) : this.getPrimaryChannel();
        if (channel != null) {
            channel.addNoticeMessage(Instant.ofEpochMilli(event.getTimestamp()), event.getMessage());
        }
        if (this.chatState.logChatToConsole) {
            LOGGER.info("{}: System {} | {}", (Object)cName, (Object)nick, (Object)event.getMessage());
        }
    }

    @SubscribeEvent
    private void onJoinEvent(JoinEvent event) {
        User user = event.getUser();
        Channel ircChannel = event.getChannel();
        if (user.getNick().equals(this.nick)) {
            if (this.chatState.logChatToConsole) {
                LOGGER.info("Join channel: " + event.getChannel().getName());
            }
            PircBotChannel channel = this.channels.computeIfAbsent(ircChannel.getName(), e -> new PircBotChannel(this.chatState, (String)e));
            channel.bindChannel(ircChannel);
            for (IrcClient.ChannelListener listener : this.channelListeners) {
                listener.channelJoin(channel);
            }
        }
    }

    @SubscribeEvent
    private void onUserList(UserListEvent event) {
        if (!event.getChannel().getName().equals(this.serverDetails.getChannel())) {
            return;
        }
        for (User u : event.getUsers()) {
            this.userSeen(u);
        }
    }

    private void userSeen(User u) {
        PircBotUser user = this.computeUser(u);
        user.bindIrcUser(u);
        Profile profile = user.getProfile();
        profile.unbanned();
        profile.markStale();
        profile.setPack(u::getRealName);
        this.chatState.profileManager.onUserOnline(profile);
    }

    @SubscribeEvent
    private void onVoiceEvent(VoiceEvent event) {
        User user = event.getRecipient();
        if (user == null) {
            return;
        }
        Profile target = this.chatState.profileManager.lookupProfileStale(user.getNick());
        if (target != this.chatState.profileManager.getOwnProfile()) {
            return;
        }
        if (event.hasVoice()) {
            this.state = IrcState.CONNECTED;
        }
    }

    @SubscribeEvent
    private void onWhois(WhoisEvent event) {
        Profile profile = this.chatState.profileManager.lookupProfileStale(event.getNick());
        if (profile == this.chatState.profileManager.getOwnProfile()) {
            return;
        }
        profile.setPack(event::getRealname);
    }

    @SubscribeEvent
    private void onBannedEvent(SetChannelBanEvent event) {
        Profile target = this.chatState.profileManager.lookupProfileStale(event.getBanHostmask().getNick());
        target.banned();
        if (target == this.chatState.profileManager.getOwnProfile()) {
            this.state = IrcState.BANNED;
            this.stop();
        }
    }

    @SubscribeEvent
    private void onUnbannedEvent(RemoveChannelBanEvent event) {
        Profile target = this.chatState.profileManager.lookupProfileStale(event.getHostmask().getNick());
        target.unbanned();
    }

    @SubscribeEvent
    private void onCTCPEvent(UnknownCTCPEvent event) {
        User user = event.getUser();
        String request = event.getRequest();
        String[] split = request.split(" ", 2);
        if (this.chatState.logChatToConsole) {
            LOGGER.info("CTCP Request: {}", (Object)request);
        }
        switch (split[0]) {
            case "FRIENDREQ": {
                if (user == null || !user.getNick().startsWith("MT")) break;
                Profile from = this.chatState.profileManager.lookupProfile(user.getNick());
                String[] split2 = split[1].split(" ", 2);
                if (split2.length < 2) break;
                this.chatState.profileManager.onIncomingFriendRequest(from, split2[0], split2[1]);
                break;
            }
            case "FRIENDACC": {
                if (user == null || !user.getNick().startsWith("MT")) break;
                Profile source = this.chatState.profileManager.lookupProfile(user.getNick());
                String[] split2 = split[1].split(" ", 2);
                if (split2.length < 2) break;
                this.chatState.profileManager.onFriendRequestAccepted(source, split2[0], split2[1]);
                break;
            }
            case "SERVERID": {
                break;
            }
            case "VERIFY": {
                if (user == null || user.getNick().startsWith("MT")) break;
                LOGGER.info("Verifying with session token.");
                event.respond(String.format("VERIFY %s:%s", this.chatState.auth.getSignature().substring(0, 15), this.chatState.auth.getSessionToken()));
                break;
            }
            default: {
                LOGGER.warn("Unknown CTCP Request from user {}: {}", (Object)user, (Object)request);
            }
        }
    }
}

